from django.contrib import admin

from adminsortable2.admin import SortableAdminMixin, SortableInlineAdminMixin

from .models import Page, Menu, MenuItem


@admin.register(Page)
class PageAdmin(admin.ModelAdmin):
    list_display = ('title', 'slug', 'status', 'updated', 'created')
    list_filter = ('created', 'updated')
    list_editable = ('status',)
    search_fields = ('title', 'slug')
    prepopulated_fields = {'slug': ('title',)}

    fieldsets = (
        (None, {
            'fields': ('title', 'slug', 'status', 'content')
        }),
        ('Advanced options', {
            'classes': ('extrapretty',),
            'fields': ('keywords', 'description', 'head_code')
        })
    )


class MenuItemInline(SortableInlineAdminMixin, admin.TabularInline):
    model = MenuItem
    extra = 0
    min_num = 1


@admin.register(Menu)
class MenuAdmin(SortableAdminMixin, admin.ModelAdmin):
    list_display = ('name', 'total_items')
    readonly_fields = ('name',)
    inlines = (MenuItemInline,)

    # override the 'list_display' to not include 'sort' by SortableAdminMixin
    def get_list_display(self, obj=None):
        return self.list_display

    def has_delete_permission(self, req, obj=None):
        return False

    def has_add_permission(self, req, obj=None):
        return False
